;Sample Add-in for TV's server
;How to install this add-in:
;-Add a value on registerkey HKEY_LOCAL_MACHINE\SOFTWARE\TV's software\TV's server\add-in
; The valuename may be random, the value should be the url to this DLL
;-Restart TV's server
;Go to localhost:81, click on Add-in and you will see this add-in in the list
;For more information go to http://www.tvsoftware.nl/server.php?page=addin

format PE GUI 4.0 DLL
entry DllStart

;---------

section '.text' executable code

;---------

include 'WIN32A.INC'

;---------

DllStart:
mov eax,1
ret 0xC

;---------

AddinData:
;0x8 = The number of the data that the server is requesting
;0xC = Reserved
push ebp
mov ebp,esp

cmp dword [ebp+0x8],0x4 ;Add-in protocol version
je SendVersiona

cmp dword [ebp+0x8],0x8 ;Add-in type
je SendType

cmp dword [ebp+0x8],0xC ;Add-in protocol
je SendProtocol

cmp dword [ebp+0x8],0x10 ;Add-in handle-proc
je SendProc

cmp dword [ebp+0x8],0x14 ;Add-in friendly name
je SendName

cmp dword [ebp+0x8],0x18 ;Add-in description
je SendDescription

cmp dword [ebp+0x8],0x1C ;Add-in version
je SendVersionb

cmp dword [ebp+0x8],0x20 ;Add-in Creator
je SendCreator

cmp dword [ebp+0x8],0x24 ;Add-in Status message
je SendStatus

cmp dword [ebp+0x8],0x28 ;Add-in Status message priority
je SendPriority

cmp dword [ebp+0x8],0x2C ;Add-in has config
je SendHasConfig

cmp dword [ebp+0x8],0x30 ;Add-in ConfigString
je SendSendConfigString

cmp dword [ebp+0x8],0x34 ;Add-in SetConfigProc
je SendSetConfigProc

jmp NoSettings

;------

SendVersiona:
mov eax,0x00000001 ;Version 1
jmp ExitAddinData

SendType:
mov eax,0x4 ;Type 1
jmp ExitAddinData

SendProtocol:
mov eax,Protocol ;Send the protocol that this add-in supports
jmp ExitAddinData

SendProc:
mov eax,HandleFunction	;Proc of the handle function
jmp ExitAddinData

SendName: ;Send Add-in name
mov eax,FriendlyName
jmp ExitAddinData

SendDescription:
mov eax,description ;Send Add-in description
jmp ExitAddinData

SendVersionb:
mov eax,version ;Send Add-in version
jmp ExitAddinData

SendCreator:
mov eax,creator ;;Send Add-in creator
jmp ExitAddinData

SendStatus:
mov eax,Status
jmp ExitAddinData

SendPriority:
mov eax,3 ;Send 3 and it will be shown on the frontpage of the settings pages
jmp ExitAddinData

SendHasConfig:
mov eax,1 ;It has a config page
jmp ExitAddinData

SendSendConfigString:
mov eax,Config ;Config string
jmp ExitAddinData

SendSetConfigProc:
mov eax,ConfigProc;Config function
jmp ExitAddinData

;------

ExitAddinData:
mov esp,ebp
pop ebp
ret 0x8

NoSettings:
mov eax,0
jmp ExitAddinData

;---------

ConfigProc:
;0x8 = Name
;0xC = Value
push ebp
mov ebp,esp

;The only name that wil lbe send is test with the new value (see string Config only input test has been configurated)

mov esp,ebp
pop ebp
ret 0x8

;---------

;You don't need to close the connection, the server will do that!
;You only need to send data
HandleFunction:
;0x8  = Socket handle
;0xC  = Pointer to everything the client has send (header + post)
;0x10 = The size off the client sended data
;0x14 = Pointer to header only
;Return value =
;1  = The server will call shutdown and wait until the client closed the connection
;-1 = The server will continue, call an other add-in if needed and send the file to the client if it is a supported protocol
push ebp
mov ebp,esp

;This example will send everything the client has send back and return 1 to close the connection
push 0
push dword [ebp+0x10]
push dword [ebp+0xC]
push dword [ebp+0x8]
call [send]

EndFunction:
mov eax,-1
mov esp,ebp
pop ebp
ret 0x10

;---------

section '.idata' import data readable
library wsock32,'WS2_32.DLL'

include 'wsock32.INC'

;---------

section '.edata' export data readable

export 'dll.DLL',\
	 AddinData,'AddinData'

;---------

section '.data' data readable writeable
;It is able to use *, on every request the function will be called (this was made to
;The string down here means on every request that starts with PUT or DELETE the function will be called
;(this MUST end with 2 zero bytes)
Protocol db '*',0,0
FriendlyName db 'Test Add-in',0
description db 'Testing add-in system',0
version db '1.01',0
creator db "TV's software",0
Status db 'Hello world',0
Config db '<TR><TD  vAlign="baseline">MyVonfigTest</TD>',\
'<TD style="WIDTH: 3px" vAlign="baseline">:</TD>',\
'<TD><INPUT id="test" style="WIDTH: 416px" type="text" size="64" name="test" value=""><br><FONT size=2>(example c:/mywebs/)</font></TD>',\
'</TR>',0



;---------

section '.reloc' fixups data discardable